/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public record DimensionTransition(ServerLevel newLevel, Vec3 pos, Vec3 speed, float yRot, float xRot, boolean missingRespawnBlock, PostDimensionTransition postDimensionTransition) {
    public static final PostDimensionTransition DO_NOTHING = $$0 -> {};
    public static final PostDimensionTransition PLAY_PORTAL_SOUND = DimensionTransition::playPortalSound;
    public static final PostDimensionTransition PLACE_PORTAL_TICKET = DimensionTransition::placePortalTicket;

    public DimensionTransition(ServerLevel $$0, Vec3 $$1, Vec3 $$2, float $$3, float $$4, PostDimensionTransition $$5) {
        this($$0, $$1, $$2, $$3, $$4, false, $$5);
    }

    public DimensionTransition(ServerLevel $$0, Entity $$1, PostDimensionTransition $$2) {
        this($$0, DimensionTransition.findAdjustedSharedSpawnPos($$0, $$1), Vec3.ZERO, 0.0f, 0.0f, false, $$2);
    }

    private static void playPortalSound(Entity $$0) {
        if ($$0 instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)$$0;
            $$1.connection.send(new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
        }
    }

    private static void placePortalTicket(Entity $$0) {
        $$0.placePortalTicket(BlockPos.containing($$0.position()));
    }

    public static DimensionTransition missingRespawnBlock(ServerLevel $$0, Entity $$1, PostDimensionTransition $$2) {
        return new DimensionTransition($$0, DimensionTransition.findAdjustedSharedSpawnPos($$0, $$1), Vec3.ZERO, 0.0f, 0.0f, true, $$2);
    }

    private static Vec3 findAdjustedSharedSpawnPos(ServerLevel $$0, Entity $$1) {
        return $$1.adjustSpawnLocation($$0, $$0.getSharedSpawnPos()).getBottomCenter();
    }

    @FunctionalInterface
    public static interface PostDimensionTransition {
        public void onTransition(Entity var1);

        default public PostDimensionTransition then(PostDimensionTransition $$0) {
            return $$1 -> {
                this.onTransition($$1);
                $$0.onTransition($$1);
            };
        }
    }
}

