/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import org.slf4j.Logger;

public abstract class SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean dirty;

    public abstract CompoundTag save(CompoundTag var1, HolderLookup.Provider var2);

    public void setDirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean $$0) {
        this.dirty = $$0;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save(File $$0, HolderLookup.Provider $$1) {
        if (!this.isDirty()) {
            return;
        }
        CompoundTag $$2 = new CompoundTag();
        $$2.put("data", this.save(new CompoundTag(), $$1));
        NbtUtils.addCurrentDataVersion($$2);
        try {
            NbtIo.writeCompressed($$2, $$0.toPath());
        }
        catch (IOException $$3) {
            LOGGER.error("Could not save data {}", (Object)this, (Object)$$3);
        }
        this.setDirty(false);
    }

    public record Factory<T extends SavedData>(Supplier<T> constructor, BiFunction<CompoundTag, HolderLookup.Provider, T> deserializer, DataFixTypes type) {
    }
}

