/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.BrainBuilder;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.ModMismatchEvent;
import net.minecraftforge.event.RegisterStructureConversionsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingMakeBrainEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.ConnectionType;
import net.minecraftforge.network.ForgePayload;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.NetworkInstance;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.packets.SpawnEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.resource.ResourcePackLoader;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ForgeHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGEHOOKS = MarkerManager.getMarker((String)"FORGEHOOKS");
    private static final Marker WORLDPERSISTENCE = MarkerManager.getMarker((String)"WP");
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    private static final ThreadLocal<Player> CRAFTING_PLAYER = new ThreadLocal();
    private static final Map<Holder.Reference<Item>, Integer> VANILLA_BURNS = new HashMap<Holder.Reference<Item>, Integer>();
    private static final Map<EntityType<? extends LivingEntity>, AttributeSupplier> FORGE_ATTRIBUTES = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier>();
    private static final Lazy<Map<String, StructuresBecomeConfiguredFix.Conversion>> FORGE_CONVERSION_MAP = Lazy.concurrentOf(() -> {
        HashMap<String, StructuresBecomeConfiguredFix.Conversion> map = new HashMap<String, StructuresBecomeConfiguredFix.Conversion>();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterStructureConversionsEvent(map));
        return ImmutableMap.copyOf(map);
    });

    private ForgeHooks() {
    }

    public static boolean canContinueUsing(@NotNull ItemStack from, @NotNull ItemStack to) {
        if (!from.isEmpty() && !to.isEmpty()) {
            return from.getItem().canContinueUsing(from, to);
        }
        return false;
    }

    public static boolean isCorrectToolForDrops(@NotNull BlockState state, @NotNull Player player) {
        if (!state.requiresCorrectToolForDrops()) {
            return ForgeEventFactory.doPlayerHarvestCheck(player, state, true);
        }
        return player.hasCorrectToolForDrops(state);
    }

    public static Brain<?> onLivingMakeBrain(LivingEntity entity, Brain<?> originalBrain, Dynamic<?> dynamic) {
        BrainBuilder brainBuilder = originalBrain.createBuilder();
        LivingMakeBrainEvent event = new LivingMakeBrainEvent(entity, brainBuilder);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return brainBuilder.makeBrain(dynamic);
    }

    public static boolean onLivingAttack(LivingEntity entity, DamageSource src, float amount) {
        return entity instanceof Player || !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static boolean onPlayerAttack(LivingEntity entity, DamageSource src, float amount) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static boolean onLivingUseTotem(LivingEntity entity, DamageSource damageSource, ItemStack totem, InteractionHand hand) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingUseTotemEvent(entity, damageSource, totem, hand));
    }

    public static float onLivingHurt(LivingEntity entity, DamageSource src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static float onLivingDamage(LivingEntity entity, DamageSource src, float amount) {
        LivingDamageEvent event = new LivingDamageEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static InteractionResult onInteractEntityAt(Entity entity, Player player, Vec3 vec3d, InteractionHand hand) {
        PlayerInteractEvent.EntityInteractSpecific ret = ForgeEventFactory.onEntityInteractSpecific(player, entity, hand, vec3d);
        if (ret.isCanceled()) {
            return ret.getCancellationResult();
        }
        return entity.interactAt(player, vec3d, hand);
    }

    public static int getLootingLevel(Entity target, @Nullable Entity killer, @Nullable DamageSource cause) {
        LivingEntity living;
        int looting = 0;
        if (killer instanceof LivingEntity) {
            living = (LivingEntity)killer;
            looting = EnchantmentHelper.getEnchantmentLevel((Holder)living.level().holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING), (LivingEntity)living);
        }
        if (target instanceof LivingEntity) {
            living = (LivingEntity)target;
            looting = ForgeEventFactory.fireLootingLevel(living, cause, looting).getLootingLevel();
        }
        return looting;
    }

    public static double getEntityVisibilityMultiplier(LivingEntity entity, Entity lookingEntity, double originalMultiplier) {
        LivingEvent.LivingVisibilityEvent event = new LivingEvent.LivingVisibilityEvent(entity, lookingEntity, originalMultiplier);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(0.0, event.getVisibilityModifier());
    }

    public static Optional<BlockPos> isLivingOnLadder(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof Player && entity.isSpectator();
        if (isSpectator) {
            return Optional.empty();
        }
        if (!((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            return state.isLadder((LevelReader)level, pos, entity) ? Optional.of(pos) : Optional.empty();
        }
        AABB bb = entity.getBoundingBox();
        int mX = Mth.floor((double)bb.minX);
        int mY = Mth.floor((double)bb.minY);
        int mZ = Mth.floor((double)bb.minZ);
        int y2 = mY;
        while ((double)y2 < bb.maxY) {
            int x2 = mX;
            while ((double)x2 < bb.maxX) {
                int z2 = mZ;
                while ((double)z2 < bb.maxZ) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    state = level.getBlockState(tmp);
                    if (state.isLadder((LevelReader)level, tmp, entity)) {
                        return Optional.of(tmp);
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return Optional.empty();
    }

    public static void onLivingJump(LivingEntity entity) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static ItemEntity onPlayerTossEvent(@NotNull Player player, @NotNull ItemStack item, boolean includeName) {
        player.captureDrops((Collection)Lists.newArrayList());
        ItemEntity ret = player.drop(item, false, includeName);
        player.captureDrops(null);
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        if (!player.level().isClientSide) {
            player.getCommandSenderWorld().addFreshEntity((Entity)event.getEntity());
        }
        return event.getEntity();
    }

    @Nullable
    public static Component onServerChatSubmittedEvent(ServerPlayer player, Component message) {
        String string;
        ComponentContents componentContents = message.getContents();
        if (componentContents instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents literalContents = (PlainTextContents.LiteralContents)componentContents;
            string = literalContents.text();
        } else {
            string = "";
        }
        String plain = string;
        ServerChatEvent event = new ServerChatEvent(player, plain, message);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? null : event.getMessage();
    }

    public static Component newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static Component newChatWithLinks(String string, boolean allowMissingHeader) {
        MutableComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            MutableComponent link;
            Object url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (!part.isEmpty()) {
                    if (ichat == null) {
                        ichat = Component.literal((String)part);
                    } else {
                        ichat.append(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = Component.literal((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = Component.literal((String)url);
                            continue;
                        }
                        ichat.append((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = Component.literal((String)url);
                        continue;
                    }
                    ichat.append((String)url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url);
            link.setStyle(link.getStyle().withClickEvent(click).withUnderlined(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
            if (ichat == null) {
                ichat = Component.literal((String)"");
            }
            ichat.append((Component)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = Component.literal((String)end);
        } else if (!end.isEmpty()) {
            ichat.append((Component)Component.literal((String)string.substring(lastEnd)));
        }
        return ichat;
    }

    public static void dropXpForBlock(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack) {
        int silkTouchLevel;
        HolderLookup lookup = level.holderLookup(Registries.ENCHANTMENT);
        int fortuneLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.FORTUNE), (ItemStack)stack);
        int exp = state.getExpDrop((LevelReader)level, level.random, pos, fortuneLevel, silkTouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack));
        if (exp > 0) {
            state.getBlock().popExperience(level, pos, exp);
        }
    }

    public static int onBlockBreakEvent(Level level, GameType gameType, ServerPlayer entityPlayer, BlockPos pos) {
        boolean preCancelEvent = false;
        ItemStack itemstack = entityPlayer.getMainHandItem();
        if (!itemstack.isEmpty() && !itemstack.getItem().canAttackBlock(level.getBlockState(pos), level, pos, (Player)entityPlayer)) {
            preCancelEvent = true;
        }
        if (entityPlayer.blockActionRestricted(level, pos, gameType)) {
            preCancelEvent = true;
        }
        BlockState state = level.getBlockState(pos);
        if (level.getBlockEntity(pos) == null) {
            level.sendBlockUpdated(pos, state, state, 3);
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            Packet pkt;
            entityPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null && (pkt = blockEntity.getUpdatePacket()) != null) {
                entityPlayer.connection.send(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static InteractionResult onPlaceItemIntoWorld(@NotNull UseOnContext context) {
        ItemStack itemstack = context.getItemInHand();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player != null && !player.getAbilities().mayBuild && !itemstack.canPlaceOnBlockInAdventureMode(new BlockInWorld((LevelReader)level, context.getClickedPos(), false))) {
            return InteractionResult.PASS;
        }
        if (!(itemstack.getItem() instanceof BucketItem)) {
            level.captureBlockSnapshots = true;
        }
        ItemStack preUse = itemstack.copy();
        InteractionResult ret = itemstack.getItem().useOn(context);
        if (itemstack.isEmpty()) {
            ForgeEventFactory.onPlayerDestroyItem(player, preUse, context.getHand());
        }
        level.captureBlockSnapshots = false;
        if (ret.consumesAction()) {
            ItemStack postUse = player.getItemInHand(context.getHand());
            ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>(level.capturedBlockSnapshots);
            level.capturedBlockSnapshots.clear();
            player.setItemInHand(context.getHand(), preUse);
            Direction side = context.getClickedFace();
            boolean eventResult = false;
            if (blockSnapshots.size() > 1) {
                eventResult = ForgeEventFactory.onMultiBlockPlace((Entity)player, blockSnapshots, side);
            } else if (blockSnapshots.size() == 1) {
                eventResult = ForgeEventFactory.onBlockPlace((Entity)player, blockSnapshots.get(0), side);
            }
            if (eventResult) {
                ret = InteractionResult.FAIL;
                for (BlockSnapshot blocksnapshot : Lists.reverse(blockSnapshots)) {
                    level.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    level.restoringBlockSnapshots = false;
                }
            } else {
                player.setItemInHand(context.getHand(), postUse);
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    BlockState oldBlock = snap.getReplacedBlock();
                    BlockState newBlock = level.getBlockState(snap.getPos());
                    newBlock.onPlace(level, snap.getPos(), oldBlock, false);
                    level.markAndNotifyBlock(snap.getPos(), level.getChunkAt(snap.getPos()), oldBlock, newBlock, updateFlag, 512);
                }
                if (player != null) {
                    player.awardStat(Stats.ITEM_USED.get((Object)preUse.getItem()));
                }
            }
        }
        level.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(AnvilMenu container, @NotNull ItemStack left, @NotNull ItemStack right, Container outputSlot, String name, long baseCost, Player player) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost, player);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (e.getOutput().isEmpty()) {
            return true;
        }
        outputSlot.setItem(0, e.getOutput());
        container.setMaximumCost((int)e.getCost());
        container.repairItemCountCost = e.getMaterialCost();
        return false;
    }

    public static boolean onGrindstoneTake(Container inputSlots, ContainerLevelAccess access, Function<Level, Integer> xpFunction) {
        access.execute((l, p) -> {
            int xp = (Integer)xpFunction.apply((Level)l);
            GrindstoneEvent.OnTakeItem e = new GrindstoneEvent.OnTakeItem(inputSlots.getItem(0), inputSlots.getItem(1), xp);
            if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                return;
            }
            if (l instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)l;
                ExperienceOrb.award((ServerLevel)server, (Vec3)Vec3.atCenterOf((Vec3i)p), (int)e.getXp());
            }
            l.levelEvent(1042, p, 0);
            inputSlots.setItem(0, e.getNewTopItem());
            inputSlots.setItem(1, e.getNewBottomItem());
            inputSlots.setChanged();
        });
        return true;
    }

    public static void setCraftingPlayer(Player player) {
        CRAFTING_PLAYER.set(player);
    }

    public static Player getCraftingPlayer() {
        return CRAFTING_PLAYER.get();
    }

    @NotNull
    public static ItemStack getCraftingRemainingItem(@NotNull ItemStack stack) {
        if (stack.getItem().hasCraftingRemainingItem(stack)) {
            if (!(stack = stack.getItem().getCraftingRemainingItem(stack)).isEmpty() && stack.isDamageableItem() && stack.getDamageValue() > stack.getMaxDamage()) {
                ForgeEventFactory.onPlayerDestroyItem(CRAFTING_PLAYER.get(), stack, (EquipmentSlot)null);
                return ItemStack.EMPTY;
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean onPlayerAttackTarget(Player player, Entity target) {
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, target))) {
            return false;
        }
        ItemStack stack = player.getMainHandItem();
        return stack.isEmpty() || !stack.getItem().onLeftClickEntity(stack, player, target);
    }

    public static InteractionResult onItemRightClick(Player player, InteractionHand hand) {
        PlayerInteractEvent.RightClickItem evt = ForgeEventFactory.onRightClickItem(player, hand);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static GameType onChangeGameType(Player player, GameType currentGameType, GameType newGameType) {
        if (currentGameType == newGameType) {
            return currentGameType;
        }
        PlayerEvent.PlayerChangeGameModeEvent evt = new PlayerEvent.PlayerChangeGameModeEvent(player, currentGameType, newGameType);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return currentGameType;
        }
        return evt.getNewGameMode();
    }

    public static <E extends LootPool> Codec<List<E>> createLootTablePoolCodec(Codec<E> vanilla) {
        final Codec list = vanilla.listOf();
        Decoder decoder = new Decoder<List<E>>(){

            public <T> DataResult<Pair<List<E>, T>> decode(DynamicOps<T> ops, T input) {
                return list.decode(ops, input).map(p -> {
                    List decoded = (List)p.getFirst();
                    for (int x = 0; x < decoded.size(); ++x) {
                        decoded.get(x);
                    }
                    return p;
                });
            }
        };
        return Codec.of((Encoder)list, (Decoder)decoder);
    }

    public static FluidType getVanillaFluidType(Fluid fluid) {
        if (fluid == Fluids.EMPTY) {
            return ForgeMod.EMPTY_TYPE.get();
        }
        if (fluid == Fluids.WATER || fluid == Fluids.FLOWING_WATER) {
            return ForgeMod.WATER_TYPE.get();
        }
        if (fluid == Fluids.LAVA || fluid == Fluids.FLOWING_LAVA) {
            return ForgeMod.LAVA_TYPE.get();
        }
        if (ForgeMod.MILK.filter(milk -> milk == fluid).isPresent() || ForgeMod.FLOWING_MILK.filter(milk -> milk == fluid).isPresent()) {
            return ForgeMod.MILK_TYPE.get();
        }
        throw new RuntimeException("Mod fluids must override getFluidType.");
    }

    public static boolean onCropsGrowPre(Level level, BlockPos pos, BlockState state, boolean def) {
        Event.Result result = ((BlockEvent.CropGrowEvent.Pre)MinecraftForge.EVENT_BUS.fire((Event)new BlockEvent.CropGrowEvent.Pre(level, pos, state))).getResult();
        return result.isAllowed() || def && result.isDefault();
    }

    public static void onCropsGrowPost(Level level, BlockPos pos, BlockState state) {
        MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.CropGrowEvent.Post(level, pos, state, level.getBlockState(pos)));
    }

    @Nullable
    public static CriticalHitEvent getCriticalHit(Player player, Entity target, boolean vanillaCritical, float damageModifier) {
        CriticalHitEvent hitResult = new CriticalHitEvent(player, target, damageModifier, vanillaCritical);
        MinecraftForge.EVENT_BUS.post((Event)hitResult);
        if (hitResult.getResult() == Event.Result.ALLOW || vanillaCritical && hitResult.getResult() == Event.Result.DEFAULT) {
            return hitResult;
        }
        return null;
    }

    public static ItemStack getProjectile(LivingEntity entity, ItemStack projectileWeaponItem, ItemStack projectile) {
        LivingGetProjectileEvent event = new LivingGetProjectileEvent(entity, projectileWeaponItem, projectile);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getProjectileItemStack();
    }

    @Nullable
    public static String getDefaultCreatorModId(@NotNull ItemStack itemStack) {
        String modId;
        Item item = itemStack.getItem();
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey(item);
        String string = modId = registryName == null ? null : registryName.getNamespace();
        if ("minecraft".equals(modId)) {
            SpawnEggItem egg;
            ResourceLocation resourceLocation;
            if (item instanceof EnchantedBookItem) {
                Holder enchant;
                Optional name;
                ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
                if (enchants.size() == 1 && (name = (enchant = (Holder)enchants.keySet().iterator().next()).unwrapKey()).isPresent()) {
                    return ((ResourceKey)name.get()).location().getNamespace();
                }
            } else if (itemStack.has(DataComponents.POTION_CONTENTS)) {
                Holder potion = ((PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)).potion().orElse(null);
                if (potion != null && potion.unwrapKey().isPresent()) {
                    return ((ResourceKey)potion.unwrapKey().get()).location().getNamespace();
                }
            } else if (item instanceof SpawnEggItem && (resourceLocation = ForgeRegistries.ENTITY_TYPES.getKey((egg = (SpawnEggItem)item).getType(itemStack))) != null) {
                return resourceLocation.getNamespace();
            }
        }
        return modId;
    }

    public static boolean onFarmlandTrample(Level level, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
        if (entity.canTrample(state, pos, fallDistance)) {
            BlockEvent.FarmlandTrampleEvent event = new BlockEvent.FarmlandTrampleEvent(level, pos, state, fallDistance, entity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public static int onNoteChange(Level level, BlockPos pos, BlockState state, int old, int _new) {
        NoteBlockEvent.Change event = new NoteBlockEvent.Change(level, pos, state, old, _new);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getVanillaNoteId();
    }

    public static boolean hasNoElements(Ingredient ingredient) {
        ItemStack[] items = ingredient.getItems();
        if (items.length == 0) {
            return true;
        }
        if (items.length == 1) {
            MutableComponent hoverName;
            Component component;
            ItemStack item = items[0];
            return item.getItem() == Items.BARRIER && (component = item.getHoverName()) instanceof MutableComponent && (hoverName = (MutableComponent)component).getString().startsWith("Empty Tag: ");
        }
        return false;
    }

    @Nullable
    public static EntityDataSerializer<?> getSerializer(int id, CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> vanilla) {
        ForgeRegistry registry;
        EntityDataSerializer serializer = (EntityDataSerializer)vanilla.byId(id);
        if (serializer == null && (registry = (ForgeRegistry)ForgeRegistries.ENTITY_DATA_SERIALIZERS.get()) != null) {
            serializer = (EntityDataSerializer)registry.getValue(id);
        }
        return serializer;
    }

    public static int getSerializerId(EntityDataSerializer<?> serializer, CrudeIncrementalIntIdentityHashBiMap<EntityDataSerializer<?>> vanilla) {
        ForgeRegistry registry;
        int id = vanilla.getId(serializer);
        if (id < 0 && (registry = (ForgeRegistry)ForgeRegistries.ENTITY_DATA_SERIALIZERS.get()) != null) {
            id = registry.getID(serializer);
        }
        return id;
    }

    public static boolean canEntityDestroy(Level level, BlockPos pos, LivingEntity entity) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        return ForgeEventFactory.getMobGriefingEvent(level, (Entity)entity) && state.canEntityDestroy((BlockGetter)level, pos, (Entity)entity) && ForgeEventFactory.onEntityDestroyBlock(entity, pos, state);
    }

    public static int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        if (stack.isEmpty()) {
            return 0;
        }
        Item item = stack.getItem();
        int ret = stack.getBurnTime(recipeType);
        return ForgeEventFactory.getItemBurnTime(stack, ret == -1 ? VANILLA_BURNS.getOrDefault(ForgeRegistries.ITEMS.getDelegateOrThrow(item), 0) : ret, recipeType);
    }

    public static synchronized void updateBurns() {
        VANILLA_BURNS.clear();
        FurnaceBlockEntity.getFuel().forEach((k, v) -> VANILLA_BURNS.put(ForgeRegistries.ITEMS.getDelegateOrThrow((Item)k), (Integer)v));
    }

    public static ObjectArrayList<ItemStack> modifyLoot(ResourceLocation lootTableId, ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        context.setQueriedLootTableId(lootTableId);
        for (IGlobalLootModifier mod : ForgeInternalHandler.getLootModifierManager().getAllLootMods()) {
            generatedLoot = mod.apply(generatedLoot, context);
        }
        return generatedLoot;
    }

    public static List<String> getModPacks() {
        List<String> modpacks = ResourcePackLoader.getPackNames();
        if (modpacks.isEmpty()) {
            throw new IllegalStateException("Attempted to retrieve mod packs before they were loaded in!");
        }
        return modpacks;
    }

    public static List<String> getModPacksWithVanilla() {
        List<String> modpacks = ForgeHooks.getModPacks();
        modpacks.add("vanilla");
        return modpacks;
    }

    @Deprecated
    public static Map<EntityType<? extends LivingEntity>, AttributeSupplier> getAttributesView() {
        return Collections.unmodifiableMap(FORGE_ATTRIBUTES);
    }

    @Deprecated
    public static void modifyAttributes() {
        ModLoader.get().postEvent((Event)new EntityAttributeCreationEvent(FORGE_ATTRIBUTES));
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> finalMap = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
        ModLoader.get().postEvent((Event)new EntityAttributeModificationEvent(finalMap));
        finalMap.forEach((k, v) -> {
            AttributeSupplier supplier = DefaultAttributes.getSupplier((EntityType)k);
            AttributeSupplier.Builder newBuilder = supplier != null ? new AttributeSupplier.Builder(supplier) : new AttributeSupplier.Builder();
            newBuilder.combine(v);
            FORGE_ATTRIBUTES.put((EntityType<? extends LivingEntity>)k, newBuilder.build());
        });
    }

    public static void writeAdditionalLevelSaveData(WorldData worldData, CompoundTag levelTag) {
        CompoundTag fmlData = new CompoundTag();
        ListTag modList = new ListTag();
        ModList.get().getMods().forEach(mi -> {
            CompoundTag mod = new CompoundTag();
            mod.putString("ModId", mi.getModId());
            mod.putString("ModVersion", MavenVersionStringHelper.artifactVersionToString(mi.getVersion()));
            modList.add((Object)mod);
        });
        fmlData.put("LoadingModList", (Tag)modList);
        CompoundTag registries = new CompoundTag();
        fmlData.put("Registries", (Tag)registries);
        LOGGER.debug(WORLDPERSISTENCE, "Gathering id map for writing to world save {}", (Object)worldData.getLevelName());
        for (Map.Entry<ResourceLocation, ForgeRegistry.Snapshot> e : RegistryManager.ACTIVE.takeSnapshot(true).entrySet()) {
            registries.put(e.getKey().toString(), (Tag)e.getValue().write());
        }
        LOGGER.debug(WORLDPERSISTENCE, "ID Map collection complete {}", (Object)worldData.getLevelName());
        levelTag.put("fml", (Tag)fmlData);
    }

    @ApiStatus.Internal
    public static void readAdditionalLevelSaveData(LevelStorageSource.LevelStorageAccess access, LevelStorageSource.LevelDirectory levelDirectory) {
        CompoundTag tag = null;
        try {
            CompoundTag rootTag = access.getDataTagRaw(false);
            tag = rootTag.getCompound("fml");
        }
        catch (IOException e) {
            try {
                CompoundTag rootTag = access.getDataTagRaw(true);
                tag = rootTag.getCompound("fml");
            }
            catch (IOException e2) {
                LOGGER.error(WORLDPERSISTENCE, "Failed to read level data.. ", (Throwable)e2);
                return;
            }
        }
        if (tag.contains("LoadingModList")) {
            ListTag modList = tag.getList("LoadingModList", 10);
            HashMap<String, ArtifactVersion> mismatchedVersions = new HashMap<String, ArtifactVersion>(modList.size());
            HashMap<String, ArtifactVersion> missingVersions = new HashMap<String, ArtifactVersion>(modList.size());
            for (int i = 0; i < modList.size(); ++i) {
                CompoundTag mod = modList.getCompound(i);
                String modId = mod.getString("ModId");
                if (Objects.equals("minecraft", modId)) continue;
                String modVersion = mod.getString("ModVersion");
                DefaultArtifactVersion previousVersion = new DefaultArtifactVersion(modVersion);
                ModList.get().getModContainerById(modId).ifPresentOrElse(container -> {
                    ArtifactVersion loadingVersion = container.getModInfo().getVersion();
                    if (!loadingVersion.equals((Object)previousVersion)) {
                        mismatchedVersions.put(modId, (ArtifactVersion)previousVersion);
                    }
                }, () -> missingVersions.put(modId, (ArtifactVersion)previousVersion));
            }
            ModMismatchEvent mismatchEvent = new ModMismatchEvent(levelDirectory, mismatchedVersions, missingVersions);
            ModLoader.get().postEvent((Event)mismatchEvent);
            StringBuilder resolved = new StringBuilder("The following mods have version differences that were marked resolved:");
            StringBuilder unresolved = new StringBuilder("The following mods have version differences that were not resolved:");
            mismatchEvent.getResolved().forEachOrdered(res -> {
                String modid = res.modid();
                ModMismatchEvent.MismatchedVersionInfo diff = res.versionDifference();
                if (res.wasSelfResolved()) {
                    resolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING, self-resolved)".formatted(modid, diff.oldVersion()) : "%s (version %s -> %s, self-resolved)".formatted(modid, diff.oldVersion(), diff.newVersion()));
                } else {
                    String resolver = res.resolver().getModId();
                    resolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING, resolved by %s)".formatted(modid, diff.oldVersion(), resolver) : "%s (version %s -> %s, resolved by %s)".formatted(modid, diff.oldVersion(), diff.newVersion(), resolver));
                }
            });
            mismatchEvent.getUnresolved().forEachOrdered(unres -> {
                String modid = unres.modid();
                ModMismatchEvent.MismatchedVersionInfo diff = unres.versionDifference();
                unresolved.append(System.lineSeparator()).append(diff.isMissing() ? "%s (version %s -> MISSING)".formatted(modid, diff.oldVersion()) : "%s (version %s -> %s)".formatted(modid, diff.oldVersion(), diff.newVersion()));
            });
            if (mismatchEvent.anyResolved()) {
                resolved.append(System.lineSeparator()).append("Things may not work well.");
                LOGGER.debug(WORLDPERSISTENCE, resolved.toString());
            }
            if (mismatchEvent.anyUnresolved()) {
                unresolved.append(System.lineSeparator()).append("Things may not work well.");
                LOGGER.warn(WORLDPERSISTENCE, unresolved.toString());
            }
        }
        Multimap<ResourceLocation, ResourceLocation> failedElements = null;
        if (tag.contains("Registries")) {
            HashMap<ResourceLocation, ForgeRegistry.Snapshot> snapshot = new HashMap<ResourceLocation, ForgeRegistry.Snapshot>();
            CompoundTag regs = tag.getCompound("Registries");
            for (String key : regs.getAllKeys()) {
                snapshot.put(ResourceLocation.parse((String)key), ForgeRegistry.Snapshot.read(regs.getCompound(key)));
            }
            failedElements = GameData.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Forge Mod Loader could not load this save.\n\n").append("There are ").append(failedElements.size()).append(" unassigned registry entries in this save.\n").append("You will not be able to load until they are present again.\n\n");
            failedElements.asMap().forEach((name, entries) -> {
                buf.append("Missing ").append(name).append(":\n");
                entries.forEach(rl -> buf.append("    ").append(rl).append("\n"));
            });
            LOGGER.error(WORLDPERSISTENCE, buf.toString());
        }
    }

    public static String encodeLifecycle(Lifecycle lifecycle) {
        if (lifecycle == Lifecycle.stable()) {
            return "stable";
        }
        if (lifecycle == Lifecycle.experimental()) {
            return "experimental";
        }
        if (lifecycle instanceof Lifecycle.Deprecated) {
            Lifecycle.Deprecated dep = (Lifecycle.Deprecated)lifecycle;
            return "deprecated=" + dep.since();
        }
        throw new IllegalArgumentException("Unknown lifecycle.");
    }

    public static Lifecycle parseLifecycle(String lifecycle) {
        if (lifecycle.equals("stable")) {
            return Lifecycle.stable();
        }
        if (lifecycle.equals("experimental")) {
            return Lifecycle.experimental();
        }
        if (lifecycle.startsWith("deprecated=")) {
            return Lifecycle.deprecated((int)Integer.parseInt(lifecycle.substring(lifecycle.indexOf(61) + 1)));
        }
        throw new IllegalArgumentException("Unknown lifecycle.");
    }

    public static boolean shouldSuppressEnderManAnger(EnderMan enderMan, Player player, ItemStack mask) {
        return mask.isEnderMask(player, enderMan) || MinecraftForge.EVENT_BUS.post((Event)new EnderManAngerEvent(enderMan, player));
    }

    @Nullable
    public static StructuresBecomeConfiguredFix.Conversion getStructureConversion(String originalBiome) {
        return (StructuresBecomeConfiguredFix.Conversion)((Map)FORGE_CONVERSION_MAP.get()).get(originalBiome);
    }

    public static boolean checkStructureNamespace(String biome) {
        @Nullable ResourceLocation biomeLocation = ResourceLocation.tryParse((String)biome);
        return biomeLocation != null && !biomeLocation.getNamespace().equals("minecraft");
    }

    public static boolean canUseEntitySelectors(SharedSuggestionProvider provider) {
        if (EntitySelectorParser.allowSelectors((Object)provider)) {
            return true;
        }
        if (provider instanceof CommandSourceStack) {
            CommandSourceStack source = (CommandSourceStack)provider;
            CommandSource commandSource = source.source;
            if (commandSource instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)commandSource;
                return PermissionAPI.getPermission(player, ForgeMod.USE_SELECTORS_PERMISSION, new PermissionDynamicContext[0]);
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public static <T> HolderLookup.RegistryLookup<T> wrapRegistryLookup(final HolderLookup.RegistryLookup<T> lookup) {
        return new HolderLookup.RegistryLookup.Delegate<T>(){

            public HolderLookup.RegistryLookup<T> parent() {
                return lookup;
            }

            public Stream<HolderSet.Named<T>> listTags() {
                return Stream.empty();
            }

            public Optional<HolderSet.Named<T>> get(TagKey<T> key) {
                return Optional.of(HolderSet.emptyNamed((HolderOwner)lookup, key));
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public static void onLivingBreathe(LivingEntity entity, int consumeAirAmount, int refillAirAmount) {
        v0 = isAir = entity.getEyeInFluidType().isAir() != false || entity.level().getBlockState(BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ())).is(Blocks.BUBBLE_COLUMN) != false;
        if (!entity.canDrownInFluidType(entity.getEyeInFluidType()) || MobEffectUtil.hasWaterBreathing((LivingEntity)entity)) ** GOTO lbl-1000
        if (entity instanceof Player) {
            player = (Player)entity;
            ** if (!player.getAbilities().invulnerable) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = true;
            ** GOTO lbl10
        }
lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
lbl10:
        // 2 sources

        canBreathe = v1;
        breatheEvent = ForgeEventFactory.onLivingBreathe(entity, isAir != false || canBreathe != false, consumeAirAmount, refillAirAmount, isAir);
        if (breatheEvent.canBreathe()) {
            if (breatheEvent.canRefillAir()) {
                entity.setAirSupply(Math.min(entity.getAirSupply() + breatheEvent.getRefillAirAmount(), entity.getMaxAirSupply()));
            }
        } else {
            entity.setAirSupply(entity.getAirSupply() - breatheEvent.getConsumeAirAmount());
        }
        if (entity.getAirSupply() <= -20 && !(drownEvent = ForgeEventFactory.onLivingDrown(entity, entity.getAirSupply() <= -20, 2.0f, 8)).isCanceled() && drownEvent.isDrowning()) {
            entity.setAirSupply(0);
            vec3 = entity.getDeltaMovement();
            for (i = 0; i < drownEvent.getBubbleCount(); ++i) {
                d2 = entity.getRandom().nextDouble() - entity.getRandom().nextDouble();
                d3 = entity.getRandom().nextDouble() - entity.getRandom().nextDouble();
                d4 = entity.getRandom().nextDouble() - entity.getRandom().nextDouble();
                entity.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, entity.getX() + d2, entity.getY() + d3, entity.getZ() + d4, vec3.x, vec3.y, vec3.z);
            }
            if (drownEvent.getDamageAmount() > 0.0f) {
                entity.hurt(entity.damageSources().drown(), drownEvent.getDamageAmount());
            }
        }
        if (!isAir && !entity.level().isClientSide && entity.isPassenger() && entity.getVehicle() != null && !entity.getVehicle().canBeRiddenUnderFluidType(entity.getEyeInFluidType(), (Entity)entity)) {
            entity.stopRiding();
        }
    }

    public static void onCreativeModeTabBuildContents(CreativeModeTab tab, ResourceKey<CreativeModeTab> tabKey, CreativeModeTab.DisplayItemsGenerator originalGenerator, CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries = new MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>(ItemStackLinkedSet.TYPE_AND_TAG, (key, left, right) -> CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        originalGenerator.accept(params, (stack, vis) -> {
            if (stack.getCount() != 1) {
                throw new IllegalArgumentException("The stack count must be 1");
            }
            entries.put(stack, vis);
        });
        ModLoader.get().postEvent((Event)new BuildCreativeModeTabContentsEvent(tab, tabKey, params, entries));
        for (Map.Entry<ItemStack, CreativeModeTab.TabVisibility> entry : entries) {
            output.accept(entry.getKey(), entry.getValue());
        }
    }

    @ApiStatus.Internal
    public static <B extends FriendlyByteBuf> StreamCodec<B, ? extends CustomPacketPayload> getCustomPayloadCodec(ResourceLocation id, int max) {
        NetworkInstance channel = NetworkRegistry.findTarget(id);
        if (channel == null) {
            return DiscardedPayload.codec((ResourceLocation)id, (int)max);
        }
        return StreamCodec.ofMember((value, buf) -> value.encoder().accept((FriendlyByteBuf)buf), buf -> {
            int len = buf.readableBytes();
            if (len < 0 || len > max) {
                throw new IllegalArgumentException("Payload may not be larger then " + max + " bytes");
            }
            return ForgePayload.create(id, buf.wrap(buf.readBytes(len)));
        });
    }

    @ApiStatus.Internal
    public static boolean onCustomPayload(CustomPacketPayload payload, Connection connection) {
        CustomPayloadEvent.Context context = new CustomPayloadEvent.Context(connection);
        return ForgeHooks.onCustomPayload(new CustomPayloadEvent(payload.type().id(), payload, context, 0));
    }

    @ApiStatus.Internal
    public static boolean onCustomPayload(ClientboundCustomQueryPacket packet, Connection connection) {
        CustomPayloadEvent.Context context = new CustomPayloadEvent.Context(connection);
        return ForgeHooks.onCustomPayload(new CustomPayloadEvent(packet.payload().id(), packet.payload(), context, packet.transactionId()));
    }

    @ApiStatus.Internal
    public static boolean onCustomPayload(ServerboundCustomQueryAnswerPacket packet, Connection connection) {
        CustomPayloadEvent.Context context = new CustomPayloadEvent.Context(connection);
        return ForgeHooks.onCustomPayload(new CustomPayloadEvent(NetworkInitialization.LOGIN_NAME, packet.payload(), context, packet.transactionId()));
    }

    @ApiStatus.Internal
    public static boolean onCustomPayload(CustomPayloadEvent event) {
        LogicalSide expectedSide;
        Connection connection = event.getSource().getConnection();
        LogicalSide logicalSide = expectedSide = connection.getReceiving() == PacketFlow.CLIENTBOUND ? LogicalSide.CLIENT : LogicalSide.SERVER;
        if (expectedSide != EffectiveSide.get()) {
            connection.disconnect((Component)Component.literal((String)"Illegal packet received, terminating connection"));
            return false;
        }
        NetworkInstance channel = NetworkRegistry.findTarget(event.getChannel());
        if (channel != null && channel.dispatch(event)) {
            return true;
        }
        if (!event.getSource().getPacketHandled()) {
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getSource().getPacketHandled();
        }
        return false;
    }

    @ApiStatus.Internal
    public static void handleClientConfigurationComplete(Connection connection) {
        if (NetworkContext.get(connection).getType() == ConnectionType.VANILLA) {
            LOGGER.info("Connected to a vanilla server. Catching up missing behaviour.");
            ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        } else {
            LOGGER.info("Connected to a modded server.");
        }
    }

    @ApiStatus.Internal
    public static Packet<ClientGamePacketListener> getEntitySpawnPacket(Entity entity) {
        if (!(entity instanceof IEntityAdditionalSpawnData)) {
            throw new IllegalArgumentException(String.valueOf(entity.getClass()) + " is not an instance of " + String.valueOf(IEntityAdditionalSpawnData.class));
        }
        IEntityAdditionalSpawnData add = (IEntityAdditionalSpawnData)entity;
        return NetworkDirection.PLAY_TO_CLIENT.buildPacket(NetworkInitialization.PLAY, new SpawnEntity(entity));
    }

    @ApiStatus.Internal
    public static boolean readAndTestCondition(RegistryOps<JsonElement> ops, JsonObject json) {
        if (!json.has("forge:condition")) {
            return true;
        }
        ICondition condition = (ICondition)ICondition.SAFE_CODEC.parse(ops, (Object)json.getAsJsonObject("forge:condition")).getOrThrow(JsonParseException::new);
        return condition.test(ConditionCodec.getContext(ops), (DynamicOps<?>)ops);
    }

    @ApiStatus.Internal
    public static void writeCondition(ICondition condition, JsonObject out) {
        if (condition == null) {
            return;
        }
        JsonElement data = (JsonElement)ICondition.CODEC.encode((Object)condition, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(JsonSyntaxException::new);
        out.add("forge:condition", data);
    }

    @Nullable
    @ApiStatus.Internal
    public static JsonObject readConditionalAdvancement(RegistryOps<JsonElement> context, JsonObject json) {
        JsonArray entries = GsonHelper.getAsJsonArray((JsonObject)json, (String)"advancements", null);
        if (entries == null) {
            return ForgeHooks.readAndTestCondition(context, json) ? json : null;
        }
        int idx = 0;
        for (JsonElement ele : entries) {
            if (!ele.isJsonObject()) {
                throw new JsonSyntaxException("Invalid advancement entry at index " + idx + " Must be JsonObject");
            }
            if (ForgeHooks.readAndTestCondition(context, ele.getAsJsonObject())) {
                return ele.getAsJsonObject();
            }
            ++idx;
        }
        return null;
    }

    @ApiStatus.Internal
    public static Codec<Ingredient> enhanceIngredientCodec(Codec<Ingredient> vanilla) {
        return Codec.lazyInitialized(() -> Codec.either((Codec)ForgeRegistries.INGREDIENT_SERIALIZERS.get().getCodec().dispatch(Ingredient::serializer, IIngredientSerializer::codec), (Codec)vanilla).flatComapMap(i -> i.left().isPresent() ? (Ingredient)i.left().get() : (Ingredient)i.right().get(), i -> DataResult.success((Object)(i.isVanilla() ? Either.right((Object)i) : Either.left((Object)i)))));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Ingredient> ingredientStreamCodec() {
        return StreamCodec.of((buf, value) -> {
            if (value.isVanilla()) {
                ItemStack[] items = value.getItems();
                ByteBufCodecs.writeCount((ByteBuf)buf, (int)items.length, (int)Integer.MAX_VALUE);
                for (ItemStack item : items) {
                    ItemStack.STREAM_CODEC.encode(buf, (Object)item);
                }
            } else {
                IIngredientSerializer serializer = value.serializer();
                ResourceLocation key = ForgeRegistries.INGREDIENT_SERIALIZERS.get().getKey(serializer);
                if (key == null) {
                    throw new IllegalArgumentException("Tried to write unregistered Ingredient to network: " + String.valueOf(value));
                }
                buf.writeVarInt(-1);
                buf.writeResourceLocation(key);
                serializer.write((RegistryFriendlyByteBuf)buf, value);
            }
        }, buf -> {
            int size = ByteBufCodecs.readCount((ByteBuf)buf, (int)Integer.MAX_VALUE);
            if (size != -1) {
                NonNullList ret = NonNullList.createWithCapacity((int)size);
                for (int x = 0; x < size; ++x) {
                    ret.add((Object)((ItemStack)ItemStack.STREAM_CODEC.decode(buf)));
                }
                return Ingredient.fromValues(ret.stream().map(Ingredient.ItemValue::new));
            }
            ResourceLocation key = buf.readResourceLocation();
            IIngredientSerializer serializer = (IIngredientSerializer)ForgeRegistries.INGREDIENT_SERIALIZERS.get().getValue(key);
            if (serializer == null) {
                throw new DecoderException("Could not read ingredient of type: " + String.valueOf(key));
            }
            return serializer.read((RegistryFriendlyByteBuf)buf);
        });
    }

    @Nullable
    public static DyeColor getDyeColorFromItemStack(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            return dye.getDyeColor();
        }
        for (int x = 0; x < DyeColor.BLACK.getId(); ++x) {
            DyeColor color = DyeColor.byId((int)x);
            if (!stack.is(color.getTag())) continue;
            return color;
        }
        return null;
    }

    public static DataComponentMap gatherItemComponents(Item item, DataComponentMap dataComponents) {
        return DataComponentMap.composite((DataComponentMap)dataComponents, (DataComponentMap)ForgeEventFactory.gatherItemComponentsEvent(item, dataComponents).getDataComponentMap());
    }

    @FunctionalInterface
    public static interface BiomeCallbackFunction {
        public Biome apply(Biome.ClimateSettings var1, BiomeSpecialEffects var2, BiomeGenerationSettings var3, MobSpawnSettings var4);
    }
}

