/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ForgeRecipeProvider
extends VanillaRecipeProvider {
    private final Map<Item, TagKey<Item>> replacements = HashMap.newHashMap(12);
    private final Set<ResourceLocation> excludes = HashSet.newHashSet(16);

    public ForgeRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup) {
        super(packOutput, lookup);
    }

    private void exclude(ItemLike item) {
        this.excludes.add(ForgeRegistries.ITEMS.getKey(item.asItem()));
    }

    private void exclude(String name) {
        this.excludes.add(ResourceLocation.parse((String)name));
    }

    private void replace(ItemLike item, TagKey<Item> tag) {
        this.replacements.put(item.asItem(), tag);
    }

    protected void buildRecipes(final RecipeOutput consumer) {
        this.replace((ItemLike)Items.STICK, Tags.Items.RODS_WOODEN);
        this.replace((ItemLike)Items.GOLD_INGOT, Tags.Items.INGOTS_GOLD);
        this.replace((ItemLike)Items.IRON_INGOT, Tags.Items.INGOTS_IRON);
        this.replace((ItemLike)Items.NETHERITE_INGOT, Tags.Items.INGOTS_NETHERITE);
        this.replace((ItemLike)Items.COPPER_INGOT, Tags.Items.INGOTS_COPPER);
        this.replace((ItemLike)Items.AMETHYST_SHARD, Tags.Items.GEMS_AMETHYST);
        this.replace((ItemLike)Items.DIAMOND, Tags.Items.GEMS_DIAMOND);
        this.replace((ItemLike)Items.EMERALD, Tags.Items.GEMS_EMERALD);
        this.replace((ItemLike)Items.CHEST, Tags.Items.CHESTS_WOODEN);
        this.replace((ItemLike)Blocks.COBBLESTONE, Tags.Items.COBBLESTONE_NORMAL);
        this.replace((ItemLike)Blocks.COBBLED_DEEPSLATE, Tags.Items.COBBLESTONE_DEEPSLATE);
        this.replace((ItemLike)Items.STRING, Tags.Items.STRINGS);
        this.exclude(ForgeRecipeProvider.getConversionRecipeName((ItemLike)Blocks.WHITE_WOOL, (ItemLike)Items.STRING));
        this.exclude((ItemLike)Blocks.GOLD_BLOCK);
        this.exclude((ItemLike)Items.GOLD_NUGGET);
        this.exclude((ItemLike)Blocks.IRON_BLOCK);
        this.exclude((ItemLike)Items.IRON_NUGGET);
        this.exclude((ItemLike)Blocks.DIAMOND_BLOCK);
        this.exclude((ItemLike)Blocks.EMERALD_BLOCK);
        this.exclude((ItemLike)Blocks.NETHERITE_BLOCK);
        this.exclude((ItemLike)Blocks.COPPER_BLOCK);
        this.exclude((ItemLike)Blocks.AMETHYST_BLOCK);
        this.exclude((ItemLike)Blocks.COBBLESTONE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLESTONE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLESTONE_WALL);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_WALL);
        super.buildRecipes(new RecipeOutput(){

            public void accept(ResourceLocation id, Recipe<?> recipe, AdvancementHolder advancement) {
                Recipe<?> modified = ForgeRecipeProvider.this.enhance(id, recipe);
                if (modified != null) {
                    consumer.accept(id, modified, advancement);
                }
            }

            public Advancement.Builder advancement() {
                return consumer.advancement();
            }

            public void accept(ResourceLocation id, Recipe<?> recipe, ResourceLocation advancementId, JsonElement advancement) {
            }

            public HolderLookup.Provider registry() {
                return consumer.registry();
            }
        });
    }

    @Nullable
    private Recipe<?> enhance(ResourceLocation id, Recipe<?> vanilla) {
        if (vanilla instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)vanilla;
            return this.enhance(id, shapeless);
        }
        if (vanilla instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)vanilla;
            return this.enhance(id, shaped);
        }
        return null;
    }

    @Nullable
    private Recipe<?> enhance(ResourceLocation id, ShapelessRecipe vanilla) {
        List ingredients = (List)ForgeRecipeProvider.getField(ShapelessRecipe.class, vanilla, 3);
        boolean modified = false;
        for (int x = 0; x < ingredients.size(); ++x) {
            Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.set(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    @Nullable
    protected CompletableFuture<?> saveAdvancement(CachedOutput output, ResourceLocation advancementId, JsonElement advancement) {
        return null;
    }

    protected CompletableFuture<?> buildAdvancement(CachedOutput p_253674_, HolderLookup.Provider p_335995_, AdvancementHolder p_297687_) {
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    @Nullable
    private Recipe<?> enhance(ResourceLocation id, ShapedRecipe vanilla) {
        ShapedRecipePattern pattern = (ShapedRecipePattern)ForgeRecipeProvider.getField(ShapedRecipe.class, vanilla, 2);
        ShapedRecipePattern.Data data = (ShapedRecipePattern.Data)pattern.data().orElseThrow(() -> new IllegalStateException("Weird shaped recipe, data is missing? " + String.valueOf(id) + " " + String.valueOf(vanilla)));
        Map ingredients = data.key();
        boolean modified = false;
        for (Character x : ingredients.keySet()) {
            Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.put(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    @Nullable
    private Ingredient enhance(ResourceLocation name, Ingredient vanilla) {
        Ingredient.Value[] vanillaItems;
        if (this.excludes.contains(name)) {
            return null;
        }
        boolean modified = false;
        ArrayList<Object> items = new ArrayList<Object>();
        for (Ingredient.Value entry : vanillaItems = (Ingredient.Value[])ForgeRecipeProvider.getField(Ingredient.class, vanilla, 3)) {
            if (entry instanceof Ingredient.ItemValue) {
                ItemStack stack = entry.getItems().stream().findFirst().orElse(ItemStack.EMPTY);
                TagKey<Item> replacement = this.replacements.get(stack.getItem());
                if (replacement != null) {
                    items.add(new Ingredient.TagValue(replacement));
                    modified = true;
                    continue;
                }
                items.add(entry);
                continue;
            }
            items.add(entry);
        }
        return modified ? Ingredient.fromValues(items.stream()) : null;
    }

    private static <T, R> R getField(Class<T> clz, T inst, int index) {
        Field fld = clz.getDeclaredFields()[index];
        fld.setAccessible(true);
        try {
            return (R)fld.get(inst);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

