/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IForgeItem {
    private Item self() {
        return (Item)this;
    }

    @Deprecated(forRemoval=true, since="1.21")
    default public ItemAttributeModifiers getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.getDefaultAttributeModifiers(stack);
    }

    default public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.self().getDefaultAttributeModifiers();
    }

    default public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return true;
    }

    default public Component getHighlightTip(ItemStack item, Component displayName) {
        return displayName;
    }

    default public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean isPiglinCurrency(ItemStack stack) {
        return stack.getItem() == PiglinAi.BARTERING_ITEM;
    }

    default public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.getItem() instanceof ArmorItem && ((ArmorItem)stack.getItem()).getMaterial() == ArmorMaterials.GOLD;
    }

    default public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    default public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
    }

    default public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return false;
    }

    default public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (!this.hasCraftingRemainingItem(itemStack)) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.self().getCraftingRemainingItem());
    }

    default public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.self().hasCraftingRemainingItem();
    }

    default public int getEntityLifespan(ItemStack itemStack, Level level) {
        return 6000;
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    @Nullable
    default public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return null;
    }

    default public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return false;
    }

    default public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    default public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        Inventory inv = player.getInventory();
        int vanillaIndex = slotIndex;
        if (slotIndex >= inv.items.size() && (vanillaIndex -= inv.items.size()) >= inv.armor.size()) {
            vanillaIndex -= inv.armor.size();
        }
        stack.inventoryTick(level, (Entity)player, vanillaIndex, selectedIndex == vanillaIndex);
    }

    default public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.getEquipmentSlotForItem(stack) == armorType;
        }
        return false;
    }

    @Nullable
    default public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return null;
    }

    default public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Nullable
    default public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean inner) {
        return null;
    }

    default public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    default public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return false;
    }

    default public int getEnchantmentValue(ItemStack stack) {
        return this.self().getEnchantmentValue();
    }

    default public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.isPrimaryItem(stack);
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (!newStack.is(oldStack.getItem())) {
            return true;
        }
        return !ItemStack.isSameItemSameComponents((ItemStack)oldStack, (ItemStack)newStack);
    }

    default public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (oldStack == newStack) {
            return true;
        }
        return !oldStack.isEmpty() && !newStack.isEmpty() && ItemStack.isSameItem((ItemStack)newStack, (ItemStack)oldStack);
    }

    @Nullable
    default public String getCreatorModId(ItemStack itemStack) {
        return ForgeHooks.getDefaultCreatorModId(itemStack);
    }

    default public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return attacker.canDisableShield();
    }

    default public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return -1;
    }

    default public void onHorseArmorTick(ItemStack stack, Level level, Mob horse) {
    }

    default public int damageItem(ItemStack stack, int damage, ServerLevel level, @Nullable ServerPlayer player, Consumer<Item> onBroken) {
        return damage;
    }

    default public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        this.self().onDestroyed(itemEntity);
    }

    default public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return stack.getItem() == Blocks.CARVED_PUMPKIN.asItem();
    }

    default public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return false;
    }

    default public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return false;
    }

    default public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is(Items.LEATHER_BOOTS);
    }

    @NotNull
    default public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        return target.getBoundingBox().inflate(1.0, 0.25, 1.0);
    }

    default public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return 0;
    }

    default public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return stack.isEnchanted();
    }

    default public boolean canGrindstoneRepair(ItemStack stack) {
        return false;
    }

    @Nullable
    default public ICapabilityProvider getCapabilityProvider(ItemStack stack) {
        return null;
    }
}

