/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

class NamespacedWrapper<T>
extends MappedRegistry<T>
implements ILockableRegistry {
    static final Logger LOGGER = LogUtils.getLogger();
    private final ForgeRegistry<T> delegate;
    @Nullable
    private final Function<T, Holder.Reference<T>> intrusiveHolderCallback;
    private final Multimap<TagKey<T>, Supplier<T>> optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
    boolean locked = false;
    Lifecycle registryLifecycle = Lifecycle.stable();
    private boolean frozen = false;
    private List<Holder.Reference<T>> holdersSorted;
    private final ObjectList<Holder.Reference<T>> holdersById = new ObjectArrayList(256);
    private final Map<ResourceLocation, Holder.Reference<T>> holdersByName = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> holders = new IdentityHashMap<T, Holder.Reference<T>>();
    private final RegistryManager stage;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();

    NamespacedWrapper(ForgeRegistry<T> fowner, Function<T, Holder.Reference<T>> intrusiveHolderCallback, RegistryManager stage) {
        super(fowner.getRegistryKey(), Lifecycle.stable(), intrusiveHolderCallback != null);
        this.delegate = fowner;
        this.intrusiveHolderCallback = intrusiveHolderCallback;
        this.stage = stage;
    }

    public Holder.Reference<T> register(ResourceKey<T> key, T value, RegistrationInfo info) {
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Objects.requireNonNull(value);
        this.markKnown();
        this.registrationInfos.put(key, info);
        this.registryLifecycle = this.registryLifecycle.add(info.lifecycle());
        this.delegate.add(-1, key.location(), value);
        return this.getHolder(key, value);
    }

    @Nullable
    public T get(@Nullable ResourceLocation name) {
        return this.delegate.getRaw(name);
    }

    public Optional<T> getOptional(@Nullable ResourceLocation name) {
        return Optional.ofNullable(this.delegate.getRaw(name));
    }

    @Nullable
    public T get(@Nullable ResourceKey<T> name) {
        return name == null ? null : (T)this.delegate.getRaw(name.location());
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return this.delegate.getKey(value);
    }

    public Optional<ResourceKey<T>> getResourceKey(T value) {
        return this.delegate.getResourceKey(value);
    }

    public boolean containsKey(ResourceLocation key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsKey(ResourceKey<T> key) {
        return this.delegate.getRegistryName().equals((Object)key.registry()) && this.containsKey(key.location());
    }

    public int getId(@Nullable T value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public T byId(int id) {
        return this.delegate.getValue(id);
    }

    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Set<ResourceLocation> keySet() {
        return this.delegate.getKeys();
    }

    public Set<ResourceKey<T>> registryKeySet() {
        return this.delegate.getResourceKeys();
    }

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return this.delegate.getEntries();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    @Deprecated
    public void lock() {
        this.locked = true;
    }

    public Optional<Holder.Reference<T>> getHolder(int id) {
        return id >= 0 && id < this.holdersById.size() ? Optional.ofNullable((Holder.Reference)this.holdersById.get(id)) : Optional.empty();
    }

    public Optional<Holder.Reference<T>> getHolder(ResourceKey<T> key) {
        return Optional.ofNullable(this.holdersByName.get(key.location()));
    }

    @NotNull
    public Holder<T> wrapAsHolder(@NotNull T value) {
        Holder holder = (Holder)this.holders.get(value);
        return holder == null ? Holder.direct(value) : holder;
    }

    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> p_331530_) {
        return Optional.ofNullable(this.registrationInfos.get(p_331530_));
    }

    public Optional<Holder.Reference<T>> getHolder(ResourceLocation location) {
        return Optional.ofNullable(this.holdersByName.get(location));
    }

    Optional<Holder<T>> getHolder(T value) {
        return Optional.ofNullable((Holder)this.holders.get(value));
    }

    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
                return Optional.of(this.getOrThrow(key));
            }

            public Holder.Reference<T> getOrThrow(ResourceKey<T> key) {
                return NamespacedWrapper.this.getOrCreateHolderOrThrow(key);
            }

            public Optional<HolderSet.Named<T>> get(TagKey<T> key) {
                return Optional.of(this.getOrThrow(key));
            }

            public HolderSet.Named<T> getOrThrow(TagKey<T> key) {
                return NamespacedWrapper.this.getOrCreateTag(key);
            }
        };
    }

    void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    void validateWrite(ResourceKey<T> key) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(key) + ")");
        }
    }

    protected Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> key) {
        return this.holdersByName.computeIfAbsent(key.location(), k -> {
            if (this.isIntrusive()) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite(key);
            return Holder.Reference.createStandAlone((HolderOwner)this.holderOwner(), (ResourceKey)key);
        });
    }

    public Optional<Holder.Reference<T>> getRandom(RandomSource rand) {
        return Util.getRandomSafe(this.getSortedHolders(), (RandomSource)rand);
    }

    public Stream<Holder.Reference<T>> holders() {
        return this.getSortedHolders().stream();
    }

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map(e -> Pair.of((Object)((TagKey)e.getKey()), (Object)((HolderSet.Named)e.getValue())));
    }

    public HolderSet.Named<T> getOrCreateTag(TagKey<T> name) {
        HolderSet.Named<T> named = this.tags.get(name);
        if (named == null) {
            named = this.createTag(name);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            map.put(name, named);
            this.tags = map;
        }
        return named;
    }

    void addOptionalTag(TagKey<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        this.optionalTags.putAll(name, defaults);
    }

    public Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    public Registry<T> freeze() {
        this.frozen = true;
        List<ResourceLocation> unregistered = this.holdersByName.entrySet().stream().filter(e -> !((Holder.Reference)e.getValue()).isBound()).map(Map.Entry::getKey).sorted().toList();
        if (!unregistered.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + unregistered.stream().map(ResourceLocation::toString).collect(Collectors.joining(", \n\t")));
        }
        if (this.unregisteredIntrusiveHolders != null && this.unregisteredIntrusiveHolders.values().stream().anyMatch(r -> !r.isBound() && r.getType() == Holder.Reference.Type.INTRUSIVE)) {
            throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()) + " Hint: Did you register all your registry objects? Registry stage: " + this.stage.getName());
        }
        return this;
    }

    public Holder.Reference<T> createIntrusiveHolder(T value) {
        if (!this.isIntrusive()) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return super.createIntrusiveHolder(value);
    }

    public Optional<HolderSet.Named<T>> getTag(TagKey<T> name) {
        return Optional.ofNullable(this.tags.get(name));
    }

    public void bindTags(Map<TagKey<T>, List<Holder<T>>> newTags) {
        IdentityHashMap<Holder.Reference<T>, List<TagKey<T>>> holderToTag = new IdentityHashMap<Holder.Reference<T>, List<TagKey<T>>>();
        for (Holder.Reference<T> tReference : this.holdersByName.values()) {
            holderToTag.put(tReference, new ArrayList());
        }
        newTags.forEach((name, values) -> values.forEach(holder -> this.addTagToHolder(holderToTag, (TagKey<T>)name, (Holder<T>)holder)));
        HashSet set = new HashSet(Sets.difference(this.tags.keySet(), newTags.keySet()));
        set.removeAll(this.optionalTags.keySet());
        if (!set.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", (Object)this.key(), (Object)set.stream().map(k -> k.location().toString()).sorted().collect(Collectors.joining(", \n\t")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> tmpTags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
        newTags.forEach((k, v) -> tmpTags.computeIfAbsent((TagKey<T>)k, this::createTag).bind(v));
        Sets.SetView defaultedTags = Sets.difference((Set)this.optionalTags.keySet(), newTags.keySet());
        for (TagKey name2 : defaultedTags) {
            List<Holder> defaults = this.optionalTags.get((Object)name2).stream().map(valueSupplier -> this.getHolder(valueSupplier.get()).orElse(null)).filter(Objects::nonNull).distinct().toList();
            for (Holder holder : defaults) {
                this.addTagToHolder(holderToTag, name2, holder);
            }
            tmpTags.computeIfAbsent(name2, this::createTag).bind(defaults);
        }
        holderToTag.forEach(Holder.Reference::bindTags);
        this.tags = tmpTags;
        this.delegate.onBindTags(this.tags, (Set<TagKey<T>>)defaultedTags);
    }

    private void addTagToHolder(Map<Holder.Reference<T>, List<TagKey<T>>> holderToTag, TagKey<T> name, Holder<T> holder) {
        if (!holder.canSerializeIn(this.holderOwner())) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(name) + " containing value " + String.valueOf(holder) + " from outside registry " + String.valueOf(this));
        }
        if (!(holder instanceof Holder.Reference)) {
            throw new IllegalStateException("Found direct holder " + String.valueOf(holder) + " value in tag " + String.valueOf(name));
        }
        holderToTag.get((Holder.Reference)holder).add(name);
    }

    public void resetTags() {
        this.tags.values().forEach(t -> t.bind(List.of()));
        this.holders.values().forEach(v -> v.bindTags(Set.of()));
    }

    public void unfreeze() {
        this.frozen = false;
    }

    boolean isFrozen() {
        return this.frozen;
    }

    public boolean isIntrusive() {
        return this.intrusiveHolderCallback != null && this.stage == RegistryManager.ACTIVE;
    }

    @Nullable
    Holder.Reference<T> onAdded(RegistryManager stage, int id, ResourceKey<T> key, T newValue, T oldValue) {
        Holder.Reference<T> newHolder = this.getHolder(key, newValue);
        this.holdersById.size(Math.max(this.holdersById.size(), id + 1));
        this.holdersById.set(id, newHolder);
        this.holdersByName.put(key.location(), newHolder);
        this.holders.put(newValue, newHolder);
        if (this.unregisteredIntrusiveHolders != null) {
            this.unregisteredIntrusiveHolders.remove(newValue);
            newHolder.bindKey(key);
        }
        newHolder.bindValue(newValue);
        this.holdersSorted = null;
        return newHolder;
    }

    private HolderSet.Named<T> createTag(TagKey<T> name) {
        return new HolderSet.Named(this.holderOwner(), name);
    }

    private Holder.Reference<T> getHolder(ResourceKey<T> key, T value) {
        if (this.isIntrusive()) {
            return this.intrusiveHolderCallback.apply(value);
        }
        return this.holdersByName.computeIfAbsent(key.location(), k -> Holder.Reference.createStandAlone((HolderOwner)this.holderOwner(), (ResourceKey)key));
    }

    private List<Holder.Reference<T>> getSortedHolders() {
        if (this.holdersSorted == null) {
            this.holdersSorted = this.holdersById.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersSorted;
    }
}

