/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraftforge.securemodules.SecureModuleClassLoader;
import net.minecraftforge.securemodules.SecureModuleFinder;

public final class ModuleLayerHandler
implements IModuleLayerManager {
    private final EnumMap<IModuleLayerManager.Layer, List<SecureJar>> layers = new EnumMap(IModuleLayerManager.Layer.class);
    private final EnumMap<IModuleLayerManager.Layer, LayerInfo> completedLayers = new EnumMap(IModuleLayerManager.Layer.class);

    ModuleLayerHandler() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ModuleLayer layer = this.getClass().getModule().getLayer();
        if (layer == null) {
            Configuration cfg = ModuleLayer.boot().configuration().resolveAndBind(ModuleFinder.of(new Path[0]), ModuleFinder.ofSystem(), List.of());
            SecureModuleClassLoader cl = new SecureModuleClassLoader("BOOT", classLoader, cfg, List.of(ModuleLayer.boot()));
            layer = ModuleLayer.boot().defineModules(cfg, m -> cl);
            System.out.println("Making new classloader: " + classLoader);
            classLoader = cl;
        }
        this.completedLayers.put(IModuleLayerManager.Layer.BOOT, new LayerInfo(layer, classLoader));
    }

    @Override
    public Optional<ModuleLayer> getLayer(IModuleLayerManager.Layer layer) {
        return Optional.ofNullable(this.completedLayers.get((Object)layer)).map(LayerInfo::layer);
    }

    void addToLayer(IModuleLayerManager.Layer layer, SecureJar jar) {
        if (this.completedLayers.containsKey((Object)layer)) {
            throw new IllegalStateException("Layer already populated");
        }
        this.layers.computeIfAbsent(layer, l -> new ArrayList()).add(jar);
    }

    @Deprecated(since="10.1")
    public LayerInfo buildLayer(IModuleLayerManager.Layer layer, BiFunction<Configuration, List<ModuleLayer>, ClassLoader> classLoaderSupplier) {
        return this.build(layer, (cfg, layers, loaders) -> (ClassLoader)classLoaderSupplier.apply(cfg, layers));
    }

    LayerInfo build(IModuleLayerManager.Layer layer) {
        return this.build(layer, (cfg, layers, loaders) -> new SecureModuleClassLoader("LAYER " + layer.name(), null, cfg, layers, loaders));
    }

    LayerInfo build(IModuleLayerManager.Layer layer, ClassLoaderFactory classLoaderSupplier) {
        SecureJar[] jars = (SecureJar[])this.layers.getOrDefault((Object)layer, List.of()).toArray(SecureJar[]::new);
        List<String> targets = Arrays.stream(jars).map(SecureJar::name).toList();
        ArrayList<ModuleLayer> parentLayers = new ArrayList<ModuleLayer>();
        ArrayList<Configuration> parentConfigs = new ArrayList<Configuration>();
        ArrayList<ClassLoader> parentLoaders = new ArrayList<ClassLoader>();
        for (IModuleLayerManager.Layer parent : layer.getParents()) {
            LayerInfo info = this.completedLayers.get((Object)parent);
            if (info == null) {
                throw new IllegalStateException("Attempted to build " + layer + " before it's parent " + parent + " was populated");
            }
            parentLayers.add(info.layer());
            parentConfigs.add(info.layer().configuration());
            parentLoaders.add(info.cl());
        }
        Configuration cfg = Configuration.resolveAndBind((ModuleFinder)SecureModuleFinder.of((SecureJar[])jars), parentConfigs, ModuleFinder.of(new Path[0]), targets);
        ClassLoader classLoader = classLoaderSupplier.create(cfg, parentLayers, parentLoaders);
        ModuleLayer newLayer = ModuleLayer.defineModules(cfg, parentLayers, module -> classLoader).layer();
        LayerInfo info = new LayerInfo(newLayer, classLoader);
        this.completedLayers.put(layer, info);
        return info;
    }

    @Deprecated(since="10.1")
    public LayerInfo buildLayer(IModuleLayerManager.Layer layer) {
        return this.build(layer);
    }

    @Deprecated(since="10.1")
    public void updateLayer(IModuleLayerManager.Layer layer, Consumer<LayerInfo> action) {
        action.accept(this.completedLayers.get((Object)layer));
    }

    record LayerInfo(ModuleLayer layer, ClassLoader cl) {
    }

    static interface ClassLoaderFactory {
        public ClassLoader create(Configuration var1, List<ModuleLayer> var2, List<ClassLoader> var3);
    }
}

