/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import java.nio.IntBuffer;
import net.neoforged.fml.earlydisplay.ColourScheme;
import net.neoforged.fml.earlydisplay.RenderElement;
import org.lwjgl.opengl.GL32C;

public class EarlyFramebuffer {
    private final int framebuffer;
    private final int texture;
    private final RenderElement.DisplayContext context;

    EarlyFramebuffer(RenderElement.DisplayContext context) {
        this.context = context;
        this.framebuffer = GL32C.glGenFramebuffers();
        this.texture = GL32C.glGenTextures();
        GL32C.glBindFramebuffer((int)36160, (int)this.framebuffer);
        GL32C.glActiveTexture((int)33984);
        GL32C.glBindTexture((int)3553, (int)this.texture);
        GL32C.glTexImage2D((int)3553, (int)0, (int)6408, (int)(context.width() * context.scale()), (int)(context.height() * context.scale()), (int)0, (int)6408, (int)5121, (IntBuffer)null);
        GL32C.glTexParameterIi((int)3553, (int)10241, (int)9728);
        GL32C.glTexParameterIi((int)3553, (int)10240, (int)9728);
        GL32C.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
        GL32C.glBindFramebuffer((int)36160, (int)0);
    }

    void activate() {
        GL32C.glBindFramebuffer((int)36160, (int)this.framebuffer);
    }

    void deactivate() {
        GL32C.glBindFramebuffer((int)36160, (int)0);
    }

    void draw(int windowFBWidth, int windowFBHeight) {
        float wscale = (float)windowFBWidth / (float)this.context.width();
        float hscale = (float)windowFBHeight / (float)this.context.height();
        float scale = (float)this.context.scale() * Math.min(wscale, hscale) / 2.0f;
        int wleft = (int)((float)windowFBWidth * 0.5f - scale * (float)this.context.width());
        int wtop = (int)((float)windowFBHeight * 0.5f - scale * (float)this.context.height());
        int wright = (int)((float)windowFBWidth * 0.5f + scale * (float)this.context.width());
        int wbottom = (int)((float)windowFBHeight * 0.5f + scale * (float)this.context.height());
        GL32C.glBindFramebuffer((int)36009, (int)0);
        GL32C.glBindFramebuffer((int)36008, (int)this.framebuffer);
        ColourScheme.Colour colour = this.context.colourScheme().background();
        GL32C.glClearColor((float)colour.redf(), (float)colour.greenf(), (float)colour.bluef(), (float)1.0f);
        GL32C.glClear((int)16384);
        GL32C.glBlitFramebuffer((int)0, (int)(this.context.height() * this.context.scale()), (int)(this.context.width() * this.context.scale()), (int)0, (int)RenderElement.clamp(wleft, 0, windowFBWidth), (int)RenderElement.clamp(wtop, 0, windowFBHeight), (int)RenderElement.clamp(wright, 0, windowFBWidth), (int)RenderElement.clamp(wbottom, 0, windowFBHeight), (int)16384, (int)9728);
        GL32C.glBindFramebuffer((int)36160, (int)0);
    }

    int getTexture() {
        return this.texture;
    }

    public void close() {
        GL32C.glDeleteTextures((int)this.texture);
        GL32C.glDeleteFramebuffers((int)this.framebuffer);
    }
}

