/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.LazyJarMetadata;
import java.lang.module.ModuleDescriptor;
import java.util.Objects;
import net.neoforged.neoforgespi.locating.IModFile;

public final class ModJarMetadata
extends LazyJarMetadata
implements JarMetadata {
    private final JarContents jarContents;
    private IModFile modFile;

    public ModJarMetadata(JarContents jarContents) {
        this.jarContents = jarContents;
    }

    public void setModFile(IModFile file) {
        this.modFile = file;
    }

    public String name() {
        return this.modFile.getModFileInfo().moduleName();
    }

    public String version() {
        return this.modFile.getModFileInfo().versionString();
    }

    public ModuleDescriptor computeDescriptor() {
        ModuleDescriptor.Builder bld = ModuleDescriptor.newAutomaticModule(this.name()).version(this.version()).packages(this.jarContents.getPackagesExcluding(new String[]{"assets", "data"}));
        this.jarContents.getMetaInfServices().stream().filter(p -> !p.providers().isEmpty()).forEach(p -> bld.provides(p.serviceName(), p.providers()));
        this.modFile.getModFileInfo().usesServices().forEach(bld::uses);
        return bld.build();
    }

    public IModFile modFile() {
        return this.modFile;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ModJarMetadata that = (ModJarMetadata)((Object)obj);
        return Objects.equals(this.modFile, that.modFile);
    }

    public int hashCode() {
        return Objects.hash(this.modFile);
    }

    public String toString() {
        return "ModJarMetadata[modFile=" + String.valueOf(this.modFile) + "]";
    }
}

