/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta.text;

import com.nothome.delta.text.CharBufferSeekableSource;
import com.nothome.delta.text.SeekableSource;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;

public class TextPatcher {
    private SeekableSource source;
    private CharBuffer buf = CharBuffer.allocate(1024);

    public TextPatcher(SeekableSource source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
    }

    public TextPatcher(CharSequence source) {
        this.source = new CharBufferSeekableSource(source);
    }

    public String patch(CharSequence patch) {
        if (patch == null) {
            throw new NullPointerException("patch");
        }
        StringWriter sw = new StringWriter();
        try {
            this.patch(new StringReader(((Object)patch).toString()), sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid patch: " + e, e);
        }
    }

    private long l(String s) {
        return Long.parseLong(s, 16);
    }

    public void patch(Reader patch, Writer out) throws IOException {
        String line;
        if (patch == null) {
            throw new NullPointerException("patch");
        }
        if (out == null) {
            throw new NullPointerException("out");
        }
        BufferedReader br = patch instanceof BufferedReader ? (BufferedReader)patch : new BufferedReader(patch);
        String header = br.readLine();
        if (header == null) {
            throw new EOFException();
        }
        if (!header.equals("gdt")) {
            throw new IOException("Unexpected header: " + header);
        }
        int lineCount = 0;
        while ((line = br.readLine()) != null) {
            ++lineCount;
            if (line.length() == 0) {
                throw new IOException("invalid empty line: " + lineCount);
            }
            char c = line.charAt(0);
            if (c == 'y') {
                int i = line.indexOf(44);
                if (i == -1) {
                    throw new IOException(", not found");
                }
                long offset = this.l(line.substring(1, i));
                long length = this.l(line.substring(i + 1));
                this.source.seek(offset);
                this.copy(this.source, out, (int)length);
                continue;
            }
            if (c == 'i') {
                long dataSize = this.l(line.substring(1));
                this.copy(br, out, (int)dataSize);
                br.readLine();
                continue;
            }
            throw new IOException("invalid patch command: " + lineCount);
        }
        out.flush();
    }

    private void copy(Readable source, Writer out, int length) throws IOException {
        while (length > 0) {
            int count;
            if (this.buf.limit() > length) {
                this.buf.limit(length);
            }
            if ((count = source.read(this.buf)) == -1) {
                throw new IOException("EOF in chunk");
            }
            this.buf.flip();
            out.append(this.buf);
            length -= count;
        }
    }
}

