/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.neoforge.common.extensions.IHolderLookupProviderExtension;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.Nullable;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.Reference<T>> listElements();

    default public Stream<ResourceKey<T>> listElementIds() {
        return this.listElements().map(Holder.Reference::key);
    }

    public Stream<HolderSet.Named<T>> listTags();

    default public Stream<TagKey<T>> listTagIds() {
        return this.listTags().map(HolderSet.Named::key);
    }

    public static interface RegistryLookup<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends Registry<? extends T>> key();

        public Lifecycle registryLifecycle();

        default public RegistryLookup<T> filterFeatures(FeatureFlagSet p_249397_) {
            return FeatureElement.FILTERED_REGISTRIES.contains(this.key()) ? this.filterElements(p_250240_ -> ((FeatureElement)p_250240_).isEnabled(p_249397_)) : this;
        }

        default public RegistryLookup<T> filterElements(final Predicate<T> p_324043_) {
            return new Delegate<T>(){

                @Override
                public RegistryLookup<T> parent() {
                    return this;
                }

                @Override
                public Optional<Holder.Reference<T>> get(ResourceKey<T> p_323784_) {
                    return this.parent().get(p_323784_).filter(p_324360_ -> p_324043_.test(p_324360_.value()));
                }

                @Override
                public Stream<Holder.Reference<T>> listElements() {
                    return this.parent().listElements().filter(p_324273_ -> p_324043_.test(p_324273_.value()));
                }
            };
        }

        @Nullable
        default public <A> A getData(DataMapType<T, A> attachment, ResourceKey<T> key) {
            return null;
        }

        public static interface Delegate<T>
        extends RegistryLookup<T> {
            public RegistryLookup<T> parent();

            @Override
            default public ResourceKey<? extends Registry<? extends T>> key() {
                return this.parent().key();
            }

            @Override
            default public Lifecycle registryLifecycle() {
                return this.parent().registryLifecycle();
            }

            default public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255619_) {
                return this.parent().get(p_255619_);
            }

            @Override
            default public Stream<Holder.Reference<T>> listElements() {
                return this.parent().listElements();
            }

            default public Optional<HolderSet.Named<T>> get(TagKey<T> p_256245_) {
                return this.parent().get(p_256245_);
            }

            @Override
            default public Stream<HolderSet.Named<T>> listTags() {
                return this.parent().listTags();
            }

            @Override
            @Nullable
            default public <A> A getData(DataMapType<T, A> attachment, ResourceKey<T> key) {
                return this.parent().getData(attachment, key);
            }
        }
    }

    public static interface Provider
    extends IHolderLookupProviderExtension {
        public Stream<ResourceKey<? extends Registry<?>>> listRegistries();

        public <T> Optional<RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);

        default public <T> RegistryLookup<T> lookupOrThrow(ResourceKey<? extends Registry<? extends T>> p_255957_) {
            return this.lookup(p_255957_).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(p_255957_.location()) + " not found"));
        }

        default public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> p_326817_) {
            return RegistryOps.create(p_326817_, this);
        }

        default public HolderGetter.Provider asGetterLookup() {
            return new HolderGetter.Provider(){

                public <T> Optional<HolderGetter<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_256379_) {
                    return this.lookup(p_256379_).map(p_255952_ -> p_255952_);
                }
            };
        }

        public static Provider create(Stream<RegistryLookup<?>> p_256054_) {
            final Map<ResourceKey, RegistryLookup> map = p_256054_.collect(Collectors.toUnmodifiableMap(RegistryLookup::key, p_256335_ -> p_256335_));
            return new Provider(){

                @Override
                public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                    return map.keySet().stream();
                }

                @Override
                public <T> Optional<RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_255663_) {
                    return Optional.ofNullable((RegistryLookup)map.get(p_255663_));
                }
            };
        }
    }
}

