/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event.entity.living;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.ApiStatus;

public class ArmorHurtEvent
extends LivingEvent
implements ICancellableEvent {
    private final EnumMap<EquipmentSlot, ArmorEntry> armorEntries;

    @ApiStatus.Internal
    public ArmorHurtEvent(EnumMap<EquipmentSlot, ArmorEntry> armorMap, LivingEntity player) {
        super(player);
        this.armorEntries = armorMap;
    }

    public ItemStack getArmorItemStack(EquipmentSlot slot) {
        return this.armorEntries.containsKey(slot) ? this.armorEntries.get((Object)slot).armorItemStack : ItemStack.EMPTY;
    }

    public Float getOriginalDamage(EquipmentSlot slot) {
        return Float.valueOf(this.armorEntries.containsKey(slot) ? this.armorEntries.get((Object)slot).originalDamage : 0.0f);
    }

    public Float getNewDamage(EquipmentSlot slot) {
        return Float.valueOf(this.armorEntries.containsKey(slot) ? this.armorEntries.get((Object)slot).newDamage : 0.0f);
    }

    public void setNewDamage(EquipmentSlot slot, float damage) {
        if (this.armorEntries.containsKey(slot)) {
            this.armorEntries.get((Object)slot).newDamage = damage;
        }
    }

    public Map<EquipmentSlot, ArmorEntry> getArmorMap() {
        return this.armorEntries;
    }

    public static class ArmorEntry {
        public ItemStack armorItemStack;
        public final float originalDamage;
        public float newDamage;

        public ArmorEntry(ItemStack armorStack, float damageIn) {
            this.armorItemStack = armorStack;
            this.originalDamage = damageIn;
            this.newDamage = damageIn;
        }
    }
}

