/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.damagesource;

import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;

@FunctionalInterface
public interface IScalingFunction {
    public static final IScalingFunction DEFAULT = (source, target, amount, difficulty) -> {
        if (source.scalesWithDifficulty()) {
            return switch (target.level().getDifficulty()) {
                default -> throw new MatchException(null, null);
                case Difficulty.PEACEFUL -> 0.0f;
                case Difficulty.EASY -> Math.min(amount / 2.0f + 1.0f, amount);
                case Difficulty.NORMAL -> amount;
                case Difficulty.HARD -> amount * 1.5f;
            };
        }
        return amount;
    };

    public float scaleDamage(DamageSource var1, Player var2, float var3, Difficulty var4);
}

