/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.advancements;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.DisplayInfo;

public class AdvancementVisibilityEvaluator {
    private static final int VISIBILITY_DEPTH = 2;

    private static VisibilityRule evaluateVisibilityRule(Advancement p_265736_, boolean p_265426_) {
        Optional<DisplayInfo> optional = p_265736_.display();
        if (optional.isEmpty()) {
            return VisibilityRule.HIDE;
        }
        if (p_265426_) {
            return VisibilityRule.SHOW;
        }
        return optional.get().isHidden() ? VisibilityRule.HIDE : VisibilityRule.NO_CHANGE;
    }

    private static boolean evaluateVisiblityForUnfinishedNode(Stack<VisibilityRule> p_265343_) {
        for (int i = 0; i <= 2; ++i) {
            VisibilityRule advancementvisibilityevaluator$visibilityrule = (VisibilityRule)((Object)p_265343_.peek(i));
            if (advancementvisibilityevaluator$visibilityrule == VisibilityRule.SHOW) {
                return true;
            }
            if (advancementvisibilityevaluator$visibilityrule != VisibilityRule.HIDE) continue;
            return false;
        }
        return false;
    }

    private static boolean evaluateVisibility(AdvancementNode p_301282_, Stack<VisibilityRule> p_301009_, Predicate<AdvancementNode> p_265359_, Output p_265303_) {
        boolean flag = p_265359_.test(p_301282_);
        VisibilityRule advancementvisibilityevaluator$visibilityrule = AdvancementVisibilityEvaluator.evaluateVisibilityRule(p_301282_.advancement(), flag);
        boolean flag1 = flag;
        p_301009_.push((Object)advancementvisibilityevaluator$visibilityrule);
        for (AdvancementNode advancementnode : p_301282_.children()) {
            flag1 |= AdvancementVisibilityEvaluator.evaluateVisibility(advancementnode, p_301009_, p_265359_, p_265303_);
        }
        boolean flag2 = flag1 || AdvancementVisibilityEvaluator.evaluateVisiblityForUnfinishedNode(p_301009_);
        p_301009_.pop();
        p_265303_.accept(p_301282_, flag2);
        return flag1;
    }

    public static void evaluateVisibility(AdvancementNode p_301203_, Predicate<AdvancementNode> p_265561_, Output p_265381_) {
        AdvancementNode advancementnode = p_301203_.root();
        ObjectArrayList stack = new ObjectArrayList();
        for (int i = 0; i <= 2; ++i) {
            stack.push((Object)VisibilityRule.NO_CHANGE);
        }
        AdvancementVisibilityEvaluator.evaluateVisibility(advancementnode, (Stack<VisibilityRule>)stack, p_265561_, p_265381_);
    }

    public static boolean isVisible(AdvancementNode advancement, Predicate<AdvancementNode> test) {
        ObjectArrayList stack = new ObjectArrayList();
        for (int i = 0; i <= 2; ++i) {
            stack.push((Object)VisibilityRule.NO_CHANGE);
        }
        return AdvancementVisibilityEvaluator.evaluateVisibility(advancement.root(), (Stack<VisibilityRule>)stack, test, (adv, visible) -> {});
    }

    static enum VisibilityRule {
        SHOW,
        HIDE,
        NO_CHANGE;

    }

    @FunctionalInterface
    public static interface Output {
        public void accept(AdvancementNode var1, boolean var2);
    }
}

